/*
 * Title  : sho_alt_log.sql
 * Author : EXADIME LLC
 * Created: 09-Sep-2018
 * Updated: 15-Sep-2021
 * Release: 1.0.0
 * Purpose: Shows alert log errors.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 1000

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

clear columns
clear computes

column sno	format 999	heading "#"
column time	format a20	heading "Timestamp"
column error	format a99	heading "Error"

accept p_row char prompt "Enter number of errors to display: "
accept p_txt char prompt "Enter search string (E.g. ORA-): "
accept p_order char prompt "Enter order by column {1|2|3} [asc|desc] " default 2

spool &&rpt_dir/sho_alt_log.rpt

select 
	row_number() over(order by &&p_row)			sno,
	to_char(originating_timestamp,'YYYY-MM-DD HH24:MI:SS')	time,
	message_text						error
from (
	select
		originating_timestamp,
		message_text
	from
		x$dbgalertext   
	where
		message_text like '%&&p_txt%'
	order by
		originating_timestamp desc
)
where	
	rownum<&&p_row
order by
	&&p_order;

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
