/*
 * Title  : ses_long_ops.sql
 * Author : EXADIME LLC
 * Created: 02-Sep-2016
 * Updated: 22-Apr-2021
 * Release: 1.0.0
 * Purpose: Shows long running sessions.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno	format 999		heading "#"
column sid      format 9999		heading "SID"
column serial#  format 99999		heading "Serial#"
column sql_id	format a13		heading "SQL Id"
column ona	format a35		heading "Open Name"
column ms	format a55		heading "Message"
column es	format 999,999		heading "Sec|Time"
column st	format a18		heading "Start Time"
column sr	format 9,999,999,999	heading "Sofar"
column tw	format 9,999,999,999	heading "Total"
column pc       format 999              heading "%|Complete"

accept p_order char prompt "Enter order by column {1|2|7|8} [asc|desc] " default 8

spool &&rpt_dir/ses_long_ops.rpt

select
	row_number() over(order by &&p_order)         "#",
	sid,
	serial#,
	sql_id,
	ona,
	ms,
	es,
	--st,
	--sr,
	--tw,
	pc
from (
	select 
		s.sid,
		s.serial#,
		s.sql_id,
		l.opname ona,
		substr(l.message,1,55) ms,
		l.elapsed_seconds es,
		to_char(l.start_time,'YYYYMMDD HH24:MI') st,
		l.sofar sr,
		l.totalwork tw,
		(l.sofar/l.totalwork)*100 pc
	from 
		v$session s,
		v$session_longops l
	where
		s.sid=l.sid
	and	s.serial#=l.serial#
	and	l.totalwork<>l.sofar
	and     l.totalwork>0
)
order by
	&&p_order
/

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
