/*
 * Title  : sch_drop_obj.sql
 * Author : EXADIME LLC
 * Created: 03-Mar-2018
 * Updated: 01-Jan-2021
 * Release: 1.0.0
 * Purpose: To drop all existing objects in the given schema. 
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 100
set pagesize 0
set pause off
set long 10000

set heading off
set headsep off
set underline off
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_owner char prompt "Enter Schema Name: "

spool &&tmp_dir/sch_drop_obj.tmp

prompt spool &&rpt_dir/sch_drop_obj.rpt
prompt 

select 
	'prompt Dropping '|| lower(object_type) || ' ' || owner || '.' || object_name || ' ...' || chr(10) ||
	'drop '||object_type||' '|| owner || '.' || object_name||
	decode(object_type,
		'TABLE',' cascade constraints;',
		'TYPE',' force;',
		';'
	)
from 
	dba_objects
where
	object_type not in ('INDEX','LOB','PACKAGE BODY','TABLE PARTITION','TABLE SUBPARTITION')
and	owner=upper('&&p_owner');

select
	'prompt Dropping public synonym ' || table_owner || '.' || synonym_name || '...' || chr(10) ||
	'drop public synonym ' || synonym_name || ';'
from
	dba_synonyms
where
	owner='PUBLIC'
and	table_owner=upper('&&p_owner');

prompt spool off

spool off

prompt Run the script "&&tmp_dir/sch_drop_obj.tmp" manually.
prompt Note: Please verify before you run this script and edit if required!

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
