/*
 * Title  : sch_comp.sql
 * Author : EXADIME LLC
 * Created: 10-Dec-2025
 * Updated: 10-Dec-2025
 * Release: 1.0.0
 * Purpose: Compile schema.
 * Comment: None
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 80
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_schema  char prompt "Enter schema name: "

spool &&rpt_dir/sch_comp.rpt

exec dbms_utility.compile_schema(schema => trim(upper('&&p_schema')), compile_all => false);

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
