/*
 * Title  : run_expl_plan.sql
 * Author : EXADIME LLC
 * Created: 31-May-2023
 * Updated: 31-May-2023
 * Release: 1.0.0
 * Purpose: Run explain plan for the given SQL text.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 4000

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_sql_text char prompt "Enter SQL text (without semi-colon): "

explain plan for &&p_sql_text
/

spool &&rpt_dir/run_expl_plan.rpt

select 
	plan_table_output 
from 
	table(dbms_xplan.display);

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off