/*
 * Title  : rmn_bct_info.sql
 * Author : EXADIME LLC
 * Created: 30-Aug-2021
 * Updated: 30-Aug-2021
 * Release: 1.0.0
 * Purpose: Shows RMAN block change tracking information.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column con_id			format	999999		heading "Id"
column filename			format  a80    		heading "File Name"	
column bytes			format  999,999,999	heading "Bytes"
column status			format  a10   		heading "Status"

spool &&rpt_dir/rmn_bct_info.rpt

select
	con_id,
	filename,
	bytes,
	status
from 
	v$block_change_tracking
/

spool off;

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 200
set long 80

set termout on
set serverout off
set feedback on
set echo off
