/*
 * Title  : pin_tune_task.sql
 * Author : EXADIME LLC
 * Created: 20-Aug-2021
 * Updated: 20-Aug-2021
 * Release: 1.0.0
 * Purpose: To load the given SQL profile.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 80
set pagesize 24
set pause off
set long 80

set heading off
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_task char prompt "Enter Task Name "
accept p_owner char prompt "Enter Owner "

spool &&rpt_dir/pin_tune_task.rpt

exec dbms_sqltune.accept_sql_profile(task_name => '&&p_task', task_owner => '&&p_owner', replace => TRUE);

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
