/*
 * Title  : pga_free.sql
 * Author : EXADIME LLC
 * Created: 01-Jun-2021
 * Updated: 01-Jun-2021
 * Release: 1.0.0
 * Purpose: Shows free space in SGA.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback on
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno      format 9999             heading "#"
column total_mb	format 9,999,999	heading "Total"
column used_mb	format 9,999,999	heading "Used"
column free_mb	format 9,999,999	heading "MB|Free"
column pct_used	format 9,999,999	heading "%|Used"

spool &&rpt_dir/sga_free.rpt

select 
    rownum sno,
    round(total_pga/1024/1024,2) total_mb,
    round(used_pga/1024/1024,2) used_mb, 
    round(free_pga/1024/1024,2) free_mb, 
    (round(used_pga/1024/1024,2)/round(total_pga/1024/1024,2))*100 pct_used
from (
    select 
        sum(case when name = 'total PGA allocated' then value else 0 end) total_pga,
        sum(case when name = 'total PGA used for auto workareas' then value 
                 when name = 'total PGA used for manual workareas' then value 
                 when name = 'total PGA inuse' then value else 0 end) used_pga,
        sum(case when name = 'total PGA allocated' then value else 0 end) - 
        sum(case when name = 'total PGA used for auto workareas' then value 
                 when name = 'total PGA used for manual workareas' then value 
                 when name = 'total PGA inuse' then value else 0 end) free_pga
    from v$pgastat
);

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
