/*
 * Title  : ggs.sql
 * Author : EXADIME LLC
 * Created: 26-Nov-2019
 * Updated: 26-Nov-2019
 * Release: 1.0.0
 * Purpose: To create Golden Gate User.
 * History: N/A
 */

start oracle.ini

accept p_password prompt 'Enter password for Golden Gate schema: '

spool &&tmp_dir/ggs.log

create user ggs identified by &&p_password 
default tablespace ggs 
temporary tablespace temp 
quota unlimited on ggs;

grant create session, connect, resource, dba to ggs; 
exec dbms_goldengate_auth.grant_admin_privilege('GGS');

--DB: 11.2.0.1 or earlier.
grant insert on system.logmnr_restart_ckpt$ to GGS;
grant update on sys.streams$_capture_process to GGS;
grant become user to GGS;

prompt Run @role_setup.sql [Located in GGS product]
prompt grant ggs_ggsuser_role to GGS;

spool off
