/*
 * Title  : exa_info.sql
 * Author : EXADIME LLC
 * Created: 30-Nov-2023
 * Updated: 01-Feb-2026
 * Release: 1.0.2
 * Purpose: Shows Exadime scripts release.
 * Comment: None
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno	format 999	heading "#"
column rel      format a7	heading "Release"
column pub	format a12	heading "Published"                      

spool &&rpt_dir/exa_info.rpt

select
	rownum               sno,
	'1.0.2'		     rel,
	'Feb 01, 2026'       pub
from
	dual;

spool off

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
