/*
 * Title  : cr_sch_syn.sql
 * Author : EXADIME LLC
 * Created: 21-Jan-2026
 * Updated: 21-Jan-2026
 * Release: 1.0.0
 * Purpose: Generates private synonyms creation script for the synonyms in the given schema.
 * Comment: Input schema name.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 200
set pagesize 0
set pause off
set long 100000

set heading off
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

accept p_user char prompt 'Enter User Name: '

variable v_tmp_file char(50)
variable v_rpt_file char(50)

exec    :v_tmp_file := 'cr_pub_syn_' || lower(trim('&&p_user')) || '.tmp'
exec    :v_rpt_file := 'cr_pub_syn_' || lower(trim('&&p_user')) || '.rpt'

column tmp_file_name new_value tmp_spool_file noprint
column rpt_file_name new_value rpt_spool_file noprint

select :v_tmp_file as tmp_file_name from dual;
select :v_rpt_file as rpt_file_name from dual;

spool &&tmp_dir/&&tmp_spool_file

prompt set feedback on echo on
prompt spool &&rpt_dir/&&rpt_spool_file
prompt 
 
select
	'CREATE SYNONYM ' || synonym_name || ' FOR ' || table_owner || '.' || table_name || ';'
from 
	dba_synonyms
where
	owner=upper('&&p_user');

prompt
prompt spool off
prompt

spool off

prompt Run the below script manually.
prompt
prompt &&tmp_dir/&&tmp_spool_file
prompt

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
