/*
 * Title  : cr_db_rp.sql
 * Author : EXADIME LLC
 * Created: 15-Sep-2025
 * Updated: 09-Dec-2025
 * Release: 1.0.0
 * Purpose: Creates guarantee restore point in the database.
 * Comment: None
 * History: FRA Check
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sn	format 99999            heading "#"
column name	format a45              heading "Name"
column scn	format 999999999999999  heading "SCN"
column inc      format 9999999	        heading "Incarnation"
column gnt	format a10		heading "Guarantee?"
column time     format a25		heading "Time"
column sz	format 999999999        heading "MB|Size"

accept p_name  char prompt "Enter restore point name: "

spool &&rpt_dir/cr_db_rp.rpt

declare
	v_count number;
	v_name varchar2(128) := upper('&&p_name');
	v_fra_size number; 
	v_log_mode varchar2(12);
begin
	if v_name is null or length(v_name) = 0 then
		dbms_output.put_line('Restore point name cannot be empty!');
		goto last;
	end if;
  
	if length(v_name) > 128 then
		dbms_output.put_line('Restore point name cannot exceed 128 characters!');
		goto last;
	end if;
  
	select count(*) into v_count from v$restore_point where name = v_name;
	if v_count > 0 then
		dbms_output.put_line('Restore point ' || v_name || ' already exists!');
		goto last;
	end if;

	select value into v_fra_size from v$parameter where name='db_recovery_file_dest_size';
	if v_fra_size = 0 then
		dbms_output.put_line('Flash recovery area not configured!');
		goto last;
	end if;

	select log_mode into v_log_mode from v$database;
	if v_log_mode != 'ARCHIVELOG' then
		dbms_output.put_line('Database is not in archive log mode!');
		goto last;
	end if;
  
	execute immediate 'create restore point &&p_name guarantee flashback database';
	dbms_output.put_line('Restore point created.');

	<<last>>
	null;
exception
	when others then
		dbms_output.put_line('ERROR: ' || sqlerrm);
		raise;
end;
/

select
        rownum  sn,
        name,
        scn,
	inc,
	gnt,
	time,
        sz
from (
	select 
	        name,
	        scn,
		database_incarnation# inc,
		guarantee_flashback_database gnt,
		to_char(time, 'Dy DD-Mon-YYYY HH24:MI:SS') as time,
	        storage_size/1024/1024 sz
	from 
		v$restore_point
	where
		name=upper('&&p_name')
);

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
