/*
 * Title  : awr_tbs_hist.sql
 * Author : EXADIME LLC
 * Created: 26-Sep-2017
 * Updated: 07-Dec-2020
 * Release: 1.0.0
 * Purpose: Shows tablespace growth statistics captured in AWR.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column rownum	 format 9999		heading "#"
column snid	 format 999999		heading "SnapId"
column time	 format a20		heading "Snap Time"
column name	 format a25		heading "Tablespace Name"
column total	 format 99,999,999,999	heading "Total"
column alloc	 format 99,999,999,999	heading "Allocated"
column used	 format 99,999,999,999	heading "Used"
column free	 format 99,999,999,999	heading "MBytes|Free"
column pct_used	 format 999.99		heading "%|Used"

accept p_tbs_name char prompt "Enter tablespace name: "

spool &&rpt_dir/awr_tbs_hist.rpt

select
	rownum,
	t.*
from (
	select
		a.snap_id											 snid,
		a.rtime												 time,
		b.name												 name,
		a.tablespace_maxsize*c.block_size/1024/1024							 total,
		a.tablespace_size*c.block_size/1024/1024							 alloc,
		a.tablespace_usedsize*c.block_size/1024/1024							 used,
		(a.tablespace_maxsize-a.tablespace_usedsize)*c.block_size/1024/1024				 free,
		(a.tablespace_usedsize*c.block_size/1024/1024)*100/(a.tablespace_maxsize*c.block_size/1024/1024) pct_used
	from
		dba_hist_tbspc_space_usage a,
		v$tablespace b,
		dba_tablespaces c
	where
		a.tablespace_id=b.ts#
	and	b.name=c.tablespace_name
	and	b.name=upper('&p_tbs_name')
	order by
		a.snap_id
) t;

spool off

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off