/*
 * Title  : awr_data_snap_hist.sql
 * Author : EXADIME LLC
 * Created: 15-Sep-2021
 * Updated: 15-Sep-2021
 * Release: 1.0.0
 * Purpose: Shows database growth by each snap captured in AWR.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno			format 99999		heading "#"
column snid			format 9999999		heading "Snap Id"
column rtime			format a20		heading "Runtime"
column total			format 999,999,999	heading "Total"
column alloc			format 999,999,999	heading "Allocated"
column used			format 999,999,999	heading "Used"
column free			format 999,999,999	heading "MB|Free"
column pct_used			format 9,999		heading "%|Used"

accept p_order char prompt "Enter display order [asc|desc]: " default asc
accept p_rows  char prompt "Enter number of records to be displayed [10]: " default 10

spool &&rpt_dir/awr_data_snap_hist.rpt

select
	row_number() over(order by 2 &&p_order) sno,
	snid,
	rtime,
	total,
	alloc,
	used,
	free,
	pct_used
from (
	select
		a.snap_id											 	snid,
		a.rtime,
		sum(a.tablespace_maxsize*c.block_size/1024/1024)							total,
		sum(a.tablespace_size*c.block_size/1024/1024)						 		alloc,
		sum(a.tablespace_usedsize*c.block_size/1024/1024)						 	used,
		sum((a.tablespace_maxsize-a.tablespace_usedsize)*c.block_size/1024/1024)		 		free,
		sum(a.tablespace_usedsize*c.block_size/1024/1024)*100/sum(a.tablespace_maxsize*c.block_size/1024/1024) 	pct_used
	from
		dba_hist_tbspc_space_usage a,
		v$tablespace b,
		dba_tablespaces c
	where
		a.tablespace_id=b.ts#
	and	
		b.name=c.tablespace_name
	and
		c.contents='PERMANENT'
	group by
		a.snap_id,
		a.rtime
	order by 
		2 &&p_order
)
where
	rownum<=&&p_rows
/

spool off

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
