/*
 * Title  : asm_oper.sql
 * Author : EXADIME LLC
 * Created: 16-Dec-2025
 * Updated: 16-Dec-2025
 * Release: 1.0.0
 * Purpose: Shows ASM operation.
 * Comment: To check dynamic rebalance status after adding disk(s).
 * History: None
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 50
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column sno		format 999	  heading "#"
column name		format a25	  heading "Group"
column operation	format a9	  heading "Operation"
column pass		format a9	  heading "Pass"
column state		format a5	  heading "State"
column power		format 99999      heading "Power"
column actual		format 999999     heading "Actual"
column sofar		format 999999     heading "Sofar"
column est_work		format 999999     heading "Work"
column est_rate		format 999999     heading "Rate"
column est_minutes	format 999999     heading "Est|Min"
column error    	format a20        heading "Error"

break on gname noduplicates

accept p_txt char prompt "Enter search string (E.g. DATA): "
accept p_order char prompt "Enter order by column {1|2|3|4|5|6|7} [asc|desc] " default 2,3,4

spool &&rpt_dir/asm_oper.rpt

select
	row_number() over(order by &&p_order) sno,
	g.name,
	o.operation,
	o.pass,
	o.state,
	o.power,
	o.actual,
	o.sofar,
	o.est_work,
	o.est_rate,
	o.est_minutes,
	substr(o.error_code,1,20) error
from
	v$asm_operation o,
	v$asm_diskgroup g
where
	g.group_number=o.group_number (+)
and	(g.name like upper('%&&p_txt%') or o.operation like upper('%&&p_txt%') or o.state like upper('%&&p_txt%'))
and	o.operation is not null
order by
	&&p_order
/

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off
