/*
 * Title  : asm_hwm.sql
 * Author : EXADIME LLC
 * Created: 12-Dec-2020
 * Updated: 12-Dec-2020
 * Release: 1.0.0
 * Purpose: High water mark in the data files for the given ASM disk group.
 * Comment: Run this script in the database not in the ASM instance.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 150
set pagesize 0
set pause off

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column id	format 9,999,999	heading "File ID"
column name	format a60		heading "File Name"
column total	format 99,999,999,999	heading "Total"
column occupied	format 99,999,999,999	heading "Occupied"
column hwm	format 99,999,999,999	heading "High Water Mark"
column save     format 99,999,999,999   heading "KBytes|Saving"
column auto	format a5		heading "Auto?"

compute sum of total	on report
compute sum of occupied on report
compute sum of hwm 	on report
compute sum of save 	on report

break on report

accept p_asm_dg char prompt "Enter ASM Disk Group Name: "

spool &&rpt_dir/asm_hwm.rpt

select  
	f.file_id						fid,
	file_name						name,
	decode(autoextensible,'YES',maxbytes/1024,bytes/1024)	total,
	bytes/1024						occupied,
	nvl(ceil((nvl(e.hwm, 0) * (select block_size from dba_tablespaces t,dba_data_files d where t.tablespace_name=d.tablespace_name and f.file_id=e.file_id and rownum<=1))/1024),0) as hwm,
	(bytes/1024)-(nvl(ceil((nvl(e.hwm, 0) * (select block_size from dba_tablespaces t,dba_data_files d where t.tablespace_name=d.tablespace_name and f.file_id=e.file_id and rownum<=1))/1024),0)) as save,
	autoextensible						auto
from
	dba_data_files f
left join(
		select 
			file_id, 
			max(block_id + blocks - 1) hwm 
		from 
			dba_extents 
		group by 
			file_id
	) e on f.file_id = e.file_id
where
	f.file_name like '+&&p_asm_dg%%'
order by
	f.file_id
/

spool off

clear columns

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80

set termout on
set serverout off
set feedback on
set echo off
