/*
 * Title  : asm_free.sql
 * Author : EXADIME LLC
 * Created: 16-Nov-2020
 * Updated: 07-Jun-2023
 * Release: 1.0.0
 * Purpose: Shows free space in ASM disk groups.
 * History: N/A
 */

start oracle.ini

set echo off
set feedback off
set serverout on
set termout on

set linesize 125
set pagesize 0
set pause off
set long 80

set heading on
set headsep on
set underline on
set colsep " "

set define on
set verify off
set escape off
set embedded on

column dummy     noprint
column sno       format 9999            heading "#"
column name      format a30             heading "Name"
column total     format 99,999,999,999  heading "Total"
column used      format 99,999,999,999  heading "Used"
column free      format 99,999,999,999  heading "MB|Free"
column pct_used  format 999.99          heading "%|Used"

compute sum of total on report
compute sum of used  on report
compute sum of free  on report

break on report

accept p_txt char prompt "Enter search string (E.g. DATA): "
accept p_order char prompt "Enter order by column {1|2|3|4|5|6} [asc|desc] " default 6

spool &&rpt_dir/asm_free.rpt

select
	row_number() over(order by &&p_order)      sno,
	name                                       name,
	total_mb                                   total,
	total_mb-free_mb                           used,
	free_mb                                    free,
	round(((total_mb-free_mb)/total_mb)*100,2) pct_used
from(
	select 
		name,
		total_mb,
		free_mb
	from 
		v$asm_diskgroup
	where (name like upper('%&&p_txt%') or name like  upper('%&&p_txt%'))
)
order by
	&&p_order
/

spool off

clear columns
clear computes

set embedded off
set escape off
set verify on
set define on

set colsep " "
set underline on
set headsep on
set heading on

set pause off
set pagesize 24
set linesize 80
set long 80

set termout on
set serverout off
set feedback on
set echo off